
//Changes 2.3.2015:
//  Added support for Kalulu. Removed "The Oh". Fixed power graphs for single phase radians.
//Changes 10.20.2014:
//  Removed code for RegEx in FNDC section. It is just overkill for a simple startsWith test

//TODO: Test multiple channels enabled on the FNDC
//		Rebuild Meters and Battery tab logic
//		Try to simplify overall structure: generatePorts(), updatePorts(), get/remove devices


///////STAR Use for file time requests? Replacement for the ajax calls to jquery?
/*
var xmlhttp;
if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
  xmlhttp=new XMLHttpRequest();
} else {// code for IE6, IE5
  xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
}
*/


//if (!OBP) var OBP = function() {}; //redundant?
var OBP = function() {};

$.extend(OBP, {
  xmlPath: "CONFIG.XML",
  jsonPath: "Dev_status.cgi?&Port=0",
  batteryJSONPath : "Dev_batt.cgi",
  xmlDoc: "",
  jsonData: "",
  batteryData: "",
  currentTab: null,
  isgs: false,			//GS instead of FX
  gssph: false,			//GS single phase
  loadcounter: 1,
  //pruned: false,
  lasttime: new Date(0), //1970
  devicecount: -1,
  deviceschanged: true, //initial run through
  fwshown: false, //is firmware displayed?
  
  updateDisplay: function() {
	
    var jsonJQXHR = $.ajax({ url: OBP.jsonPath + "?" + Math.random(), dataType: 'json', success: OBP.updateJSON, error: OBP.updateJSONError, context: OBP});
    
    OBP.loadcounter = OBP.loadcounter - 1;
    if (OBP.loadcounter <= 0) {//We don't have to process this often
        //$('#page_load_status').html('Getting system configuration...');
    	//var xmlJQXHR = $.ajax({ url: this.xmlPath, dataType: 'xml', success: this.updateXML, error: this.updateXMLError, context: this});
    	var xmlJQXHR = $.ajax({ url: OBP.xmlPath, dataType: 'xml', ifModified: true, success: OBP.updateXML, error: OBP.updateXMLError, context: OBP});
    	OBP.loadcounter = 8;
        
    }
    var batteryJQXHR = $.ajax({ url: OBP.batteryJSONPath + "?" + Math.random(), dataType: 'json', success: OBP.updateBattery, error: OBP.updateJSONError, context: OBP});
    
    
    //try to limit the amount of times things are rebuilt on the web page
    if (OBP.jsonData !== "") {
        var ports = OBP.jsonData.devstatus.ports;
                  
        if (ports.length !== OBP.devicecount) {
            OBP.devicecount = ports.length;
            OBP.deviceschanged = true;
        }
    }
    
    
  },
  
  updateBattery: function(json) {
    OBP.batteryData = json;
    OBP.Battery.update();
  },
  
  updateJSON: function(json) {
    OBP.jsonData = json;
    if (OBP.deviceschanged) {
        OBP.hideUnusedDevs(); //once is enough
        OBP.updatePorts();
		//OBP.pruned = true;
		OBP.fwshown = false;
    }
    
	//this.Firmware.update(); //only need updating one time
    if (!(OBP.fwshown)) {
        //with download delays, I could not figure a better way to do this than with a boolean (or else call it every refresh)
        OBP.Firmware.update(); //if you need this updated, your system has been shut down anyway, hit refresh
	OBP.fwshown = true;
    }
	
		
    OBP.Status.update();
	
    OBP.Meters.update();
    //OBP.Meters.fillPorts();
	
	OBP.newMode.update();
	
    OBP.updateGraphs();
	
	var frmtcall = OBP.frmtLabel;
    //Does this help make it faster?
	frmtcall('.mvac', " VAC"); //Careful, Meters only updated this often
	frmtcall('.mvdc', " VDC");
	frmtcall('.maac', " AAC");
	frmtcall('.madc', " ADC");
	frmtcall('.mah', " Ah");
	frmtcall('.mkwh', " kWh");
	frmtcall('.mday', " Days");
	frmtcall('.mperc', " %");
	frmtcall('.mdeg', " Degrees C");
	
  },
  
  frmtHRMIN: function(selection) {
	$( selection ).each(function(index) {
		var field = $(this);
		field.text( ("0" + field.text()).slice(-2) );
	});
  },
  
  frmtNumber: function(selection, multiple, precision) {
	$( selection ).each(function(index) {
		var txt = $(this).text();
		if (txt !== "") {
			if (txt !== "24/7") { //Float time is All Day
				var val = ($(this).text() * multiple).toFixed(precision);
				
				if ( (!isNaN (val-0)) && (val!==null) ) {
					$(this).text( val );
				} else {
					$(this).text( "N/A" );
				}
			}
		}
	});
  },
  
  frmtLabel: function(selection, label) {
	$( selection ).each(function(index) {
		var txt = $(this).text();
		if ((txt === "N/A") || (txt === "24/7")) {  //if 24/7, Float time is All Day
			//don't change anything
                        //this open block is on purpose, order of tests matter
			
		} else if (txt !== "") {
			$(this).text( txt + label );
			
		} else {
			$(this).text( "N/A" );
		}
	});
  },

  //updateXML: function(xml) {
  updateXML: function(xml, statusText) {
    
    if (statusText !== "notmodified") { //Use jquery's if-modified-since feature
        OBP.xmlDoc = $(xml);
        
	    //OBP.Config.update();
        //OBP.modSetup.update();
	    OBP.populateXML.exec();
		
		//OBP.modSetup.fillPorts(); //only need it when things change, right?
		
		
		OBP.frmtNumber('.divby10', 0.1, 1);
                OBP.frmtNumber('.tfrdelay', 0.02, 2);
		OBP.frmtHRMIN('.hrmin');
		
		
		//faster?
		var frmtcall = OBP.frmtLabel;
		frmtcall('.vac', " VAC");
		frmtcall('.vdc', " VDC");
		frmtcall('.aac', " AAC");
		frmtcall('.adc', " ADC");
		frmtcall('.kw', " kW");
		frmtcall('.ah', " Ah");
		frmtcall('.cyc', " Cycles");
		frmtcall('.milliv', " mV");
		frmtcall('.days', " Days");
		frmtcall('.min', " Minutes");
		frmtcall('.hr', " Hours");
		frmtcall('.sec', " Seconds");
		frmtcall('.wk', " Weeks");
		frmtcall('.perc', " %");
		frmtcall('.watts', " W");
		
	}
    
  },
  
  
  hideUnusedDevs: function() {
    if (OBP.getCCs().length === 0) {
      $(".cc_section").remove();
    }
    //Added conditions for GS
    if (this.getInvs().length > 0) { //if we have inverters
    	if (OBP.isgs) {
    		$(".inv_section").remove(); //if they are GS, remove FX fields
    	} else {
    		$(".gs_section").remove(); //Otherwise, remove GS fields
    	}
    } else { //No inverters
    	$(".inv_section").remove();
    	$(".gs_section").remove();
    }
    
    var fndc = OBP.getFNDC();
    if (fndc === undefined) {
      $(".fndc_section").remove();
    }/* else {
      jQuery.each(fndc.Enabled, function(index, value) { 
        var selector = ".channel_" + value.toLowerCase();
        $(selector).show();
      });
    }*/
          
  },
  
  
  generatePorts: function(selection, devices) {
	
	$( selection ).each(function(index) {
		for (var idx=0; idx<devices.length; idx++) {
			var clonedrow = $(this).clone();
			clonedrow.toggle();
			
			var newpn = devices[idx]["Port"];
			var rowHeader = clonedrow.children(".table_port_number");
			
			rowHeader.html( "Port " + newpn );
			clonedrow.attr('id', clonedrow.attr('id') + '_' + newpn); 
			$.each(clonedrow.children(), function(index, value) {
				if (index > 0) {
					$(this).attr('id', $(this).attr('id') + '_' + newpn ); 
				}
			});
			
			clonedrow.removeClass('duprow');
			$(this).parent().append( clonedrow );
		}
		//only copy once
		$(this).removeClass('duprow');
			
	});
  
  },
  
  
  updatePorts: function() {
    // we can only display the ports data on the mode tab after we have valid data from both sources.
    //if (this.jsonData != "" && this.xmlDoc != "") this.Mode.updatePorts();

    if (OBP.jsonData !== "") {
		if (OBP.deviceschanged) {
		
			var portbuilder = OBP.generatePorts;
		
			var inverts = OBP.getInvs();
			if (OBP.isgs) {
				portbuilder( '.gs_section .duprow', inverts );
			} else {
				portbuilder( '.inv_section .duprow', inverts );
			}
			portbuilder( '.cc_section .duprow', OBP.getCCs() );
			
			if (OBP.isgs) {
				OBP.Meters.constructGS();
			}
			
			//append port number to FNDC fields (only from XML)
			//		as it makes parsing the XML file easier
			devdc = OBP.getFNDC();
			$('.fnfield').each(function(index) {
				var prt = devdc["Port"];
				
				$(this).attr('id', $(this).attr('id') + '_' + prt );
				$(this).removeClass('fnfield'); //prevent adding a duplicate "_portnum" to each field, should not happen, but timing varies with network
					
			});
			
			OBP.deviceschanged = false;
			
        }
    }
  },

  updateGraphs: function() {
    if (OBP.jsonData !== "" && OBP.xmlDoc !== "") {
      OBP.buildGraphPVOutput();
      
      OBP.buildGraphINV();
//      if (OBP.isgs) {
//    	  OBP.buildGraphGS();
//      } else {
//    	  OBP.buildGraphInverterOutput();
//    	  OBP.buildGraphInverterLoad();
//      }
    }  
  },
  

  buildGraphINV: function() {
	  
	  
      var invlist = OBP.getInvs();
	  
      var inverterListItem = $("#graph_inv_output");
      var inverterInputListItem = $("#graph_inv_input");
      var chargerListItem = $("#graph_charger_output");
	  
      var scale = (parseInt( OBP.xmlDoc.find("Max_Inverter_Output_KW").first().text(), 10 ) / 1000) + (parseInt( OBP.xmlDoc.find("Max_Charger_Output_KW").first().text(), 10 ) / 1000); 
      //if scales are (value/10)kW then dividing by 1000 (instead of 10)
      //		will correctly scale the percent to a number between 0-100.00
      
      //alert(scale);
	  
	  var Inv_VA = 0;
	  var Buy_VA = 0;
	  var Chr_VA = 0;
	  var Sell_VA = 0;
	  
	  if (OBP.isgs) {
              
            if (OBP.gssph) { //Single phase Radian or FXR
                $.each(invlist, function(index, value) {
		  Inv_VA += value["Inv_I_L2"]*value["VAC_out_L2"];

                        //handle UNDEFINED entry...
                  var vacin1 = 0;
                  var vacin2 = 0;

                  var selectedinput = value["AC_Input"];
                  var invtype = value["Dev"];
                  
                  if ( (selectedinput === "Grid") || (invtype === "FXR") ) {
                          vacin2 = value["VAC1_in_L2"];
                  } else {
                          vacin2 = value["VAC2_in_L2"];
                  }
                  
                  Sell_VA += value["Sell_I_L2"]*vacin2;
                  Buy_VA += value["Buy_I_L2"]*vacin2;
                  Chr_VA += value["Chg_I_L2"]*vacin2;
		} );
                
            } else {
                $.each(invlist, function(index, value) {
		  Inv_VA += value["Inv_I_L1"]*value["VAC_out_L1"] + value["Inv_I_L2"]*value["VAC_out_L2"];

                        //handle UNDEFINED entry...
                  var vacin1 = 0;
                  var vacin2 = 0;

                  var selectedinput = value["AC_Input"];
                  if (selectedinput === "Grid") {
                          vacin1 = value["VAC1_in_L1"];
                          vacin2 = value["VAC1_in_L2"];
                  } else {
                          vacin1 = value["VAC2_in_L1"];
                          vacin2 = value["VAC2_in_L2"];
                  }
                  Sell_VA += value[ "Sell_I_L1"]*vacin1 + value["Sell_I_L2"]*vacin2;
                  Buy_VA += value["Buy_I_L1"]*vacin1 + value["Buy_I_L2"]*vacin2;
                  Chr_VA += value["Chg_I_L1"]*vacin1 + value["Chg_I_L2"]*vacin2;
		} );
            }
            
	  } else {
		$.each(invlist, function(index, value) {
                    Inv_VA += value["Inv_I"]*value["VAC_out"];

                    var vacin = value["VAC_in"];
                    Sell_VA += value["Sell_I"]*vacin;
                    Buy_VA += value["Buy_I"]*vacin;
                    Chr_VA += value["Chg_I"]*vacin;
		} );
	  
	  }

	  //Scale 'em back
	  Inv_VA /= 1000.0;
	  Buy_VA /= 1000.0;
	  Chr_VA /= 1000.0;
	  Sell_VA /= 1000.0;
		
	  if (Buy_VA > 0) { //buying
		var percentValue = (Chr_VA / scale).toFixed(2);
        if (percentValue > 100.00) percentValue = 100.00;
        var width = percentValue + "%";
        var graphDivElement = chargerListItem.children(".status").show();
        graphDivElement.children(".blue").width(width);
        graphDivElement.siblings(".value").text(Chr_VA.toFixed(1) + " kW");
        chargerListItem.children("strong").text("Charging");
        
	    if (Inv_VA > 0) { //buy & invert = support mode
	    	percentValue = ((Buy_VA + Inv_VA) / scale).toFixed(2);
		    if (percentValue > 100.00) percentValue = 100.00;
		    width = percentValue + "%";
		    graphDivElement = inverterInputListItem.children(".status").show();
		    graphDivElement.children(".blue").width(width);
		    graphDivElement.siblings(".value").text((Buy_VA + Inv_VA).toFixed(1) + " kW");
		    inverterInputListItem.children("strong").text("AC Load");
	    	
	    	percentValue = (Inv_VA / scale).toFixed(2);
		    if (percentValue > 100.00) percentValue = 100.00;
		    width = percentValue + "%";
		    graphDivElement = inverterListItem.children(".status").show();
		    graphDivElement.children(".blue").width(width);
		    graphDivElement.siblings(".value").text(Inv_VA.toFixed(1) + " kW");
		    inverterListItem.children("strong").text("Support");
		    
	    } else {
	    	percentValue = ((Buy_VA - Chr_VA) / scale).toFixed(2);
		    if (percentValue > 100.00) percentValue = 100.00;
		    width = percentValue + "%";
		    graphDivElement = inverterInputListItem.children(".status").show();
		    graphDivElement.children(".blue").width(width);
		    graphDivElement.siblings(".value").text((Buy_VA - Chr_VA).toFixed(1) + " kW");
		    inverterInputListItem.children("strong").text("AC Load");
		    
	    	graphDivElement = inverterListItem.children(".status").show();
		    graphDivElement.children(".blue").width("0%");
		    graphDivElement.siblings(".value").text("0.0 kW");
		    inverterListItem.children("strong").text("Inverting");
	    }
	    
	    
	  } else if (Sell_VA > 0) { //selling
		var percentValue = (Sell_VA / scale).toFixed(2);
        if (percentValue > 100.00) percentValue = 100.00;
        var width = percentValue + "%";
        var graphDivElement = inverterListItem.children(".status").show();
        graphDivElement.children(".blue").width(width);
        graphDivElement.siblings(".value").text(Sell_VA.toFixed(1) + " kW");
        inverterListItem.children("strong").text("Selling");
        
        percentValue = ((Inv_VA - Sell_VA) / scale).toFixed(2);
	    if (percentValue > 100.00) percentValue = 100.00;
	    width = percentValue + "%";
	    graphDivElement = inverterInputListItem.children(".status").show();
	    graphDivElement.children(".blue").width(width);
	    graphDivElement.siblings(".value").text((Inv_VA - Sell_VA).toFixed(1) + " kW");
	    inverterInputListItem.children("strong").text("AC Load");
	    
	    graphDivElement = chargerListItem.children(".status").show();
	    graphDivElement.children(".blue").width("0%");
	    graphDivElement.siblings(".value").text("0.0 kW");
	    chargerListItem.children("strong").text("Charging");
	    
	  } else { //inverting
		var percentValue = (Inv_VA / scale).toFixed(2);
        if (percentValue > 100.00) percentValue = 100.00;
        var width = percentValue + "%";
        var graphDivElement = inverterListItem.children(".status").show();
        graphDivElement.children(".blue").width(width);
        graphDivElement.siblings(".value").text(Inv_VA.toFixed(1) + " kW");
        inverterListItem.children("strong").text("Inverting");
        
        //percentValue = ((Inv_VA - Sell_VA) / scale).toFixed(2);
	    //if (percentValue > 100.00) percentValue = 100.00;
	    //width = percentValue + "%";
	    graphDivElement = inverterInputListItem.children(".status").show();
	    graphDivElement.children(".blue").width(width);
	    graphDivElement.siblings(".value").text(Inv_VA.toFixed(1) + " kW");
	    inverterInputListItem.children("strong").text("AC Load");
	    
	    graphDivElement = chargerListItem.children(".status").show();
	    graphDivElement.children(".blue").width("0%");
	    graphDivElement.siblings(".value").text("0.0 kW");
	    chargerListItem.children("strong").text("Charging");
	  }
  },
  
  
  buildGraphPVOutput: function() {
    // If 1 or more charge controllers are detected within data returned from JSON Dev_status call
    //  For each charge controller sum (Out_I * Batt_V) = total watts
    //  Scale bacgraph using config.XML data item PV_Size_Watts as the maximum PV output value
    var ccs = OBP.getCCs();
    if (ccs.length > 0) {
      var totalWatts = 0;
      $.each(ccs, function(index, value) {
        totalWatts += value["Out_I"] * value["Batt_V"];
      });
      totalWatts = Math.round(totalWatts / 10) * 10;
      var valueNode = OBP.xmlDoc.find("PV_Size_Watts").first();
      var scale = valueNode.text();
      var percentValue = (totalWatts / scale * 100).toFixed(2);
      if (percentValue > 100.00) percentValue = 100.00;
      var width = percentValue + "%";
      var graphDivElement = $("#graph_pv_output .status").show(); //why is a class needed with ID?
      graphDivElement.children(".blue").width(width);
      graphDivElement.siblings(".value").text(totalWatts + " W");
    }
  },
  
    
  // TODO have 'subclasses' extend the OBP prototype to get access to these methods via 'this'
  getDevices: function(deviceName) {
    // TODO: should probably check to make sure that the json has been loaded for robustness
	  //TODONE: ^
	  var devices = [];
	  if (OBP.jsonData !== "") {
		  var ports = OBP.jsonData.devstatus.ports;
                  
		  for(var name in ports) {
			  if (ports[name].Dev === deviceName) {
				  devices.push(ports[name]);
			  }
		  }
	  }
    return devices;
  },

  //sortPortNum: function(a, b) {
  //  return ((a.Port < b.Port) ? -1 : ((a.Port > b.Port) ? 1 : 0));
  //},

  getInvs: function() {	//why were these ever sorted?
	var tmpdevs = this.getDevices('FX');
	
	if (tmpdevs.length !== 0) {
		return tmpdevs;//.sort(OBP.sortPortNum);
	} else {
		var gsunits = OBP.getDevices('GS');//.sort(OBP.sortPortNum);
		var gss = OBP.getDevices('GSS');//.sort(OBP.sortPortNum); //not very efficient but...
                var fxr = OBP.getDevices('FXR');
                
		if (gsunits.length > 0) {
			OBP.isgs = true;
                        
		} else if (gss.length > 0) { //Single phase Radian
			OBP.isgs = true;
			OBP.gssph = true;
			return gss;
                        
                } else if (fxr.length > 0) {
                        OBP.isgs = true;	//same flag but make sure it counts the GSS
			OBP.gssph = true;
                        //For FXRs, set "Radian" headers to "Inverter"...
                        $("div.info.gs_section > h3").each(function() {
                            $(this).html("Inverter");
                        });
                        //...hide settings that an FXR does not have...
                        $(".notFXR").hide();
                        
                        //...and show those it does
                        $(".isFXR").show();

                        return fxr;
                    
		} else {
			OBP.isgs = false;
		}
		return gsunits;	//all else, this could be empty
	}
  },

  getCCs: function() {
    return OBP.getDevices('CC');//.sort(this.sortPortNum);
  },

  getFNDC: function() {
    // This is assuming that there can only ever be 1 FNDC device on a system
    return OBP.getDevices('FNDC')[0];
  },

  getGlobalInverter: function() {
	return OBP.getInvs()[0]; //why does this need sorting when the original list is
    //return this.getInvs().sort(this.sortPortNum)[0];
  },

  displaySection: function(sectionTab) {
    var sectionDivid = sectionTab.attr('id').replace("_tab", "");
    $('div.content').each( function(index) {
      if (this.id === sectionDivid) {
        $(this).show();
      } else {
        $(this).hide();
      }
    });
    if (this.currentTab) this.currentTab.removeClass('selected');
    sectionTab.addClass('selected');
    this.currentTab = sectionTab;
  },
  
  getShortTime: function(date) {
	    var hours = date.getHours();
	    var minutes = date.getMinutes();
	    var meridiem = "AM";
	    if (hours >= 12) {
	    	meridiem = "PM";
	    	hours = hours - 12;
	    }
	    if (hours === 0) {
	    	hours = 12;
	    }
	    if (hours < 10) hours = "0" + hours; //keep text width the same
	    if (minutes < 10) minutes = "0" + minutes;
	    
	    return ( hours + ":" + minutes + " " + meridiem );
  },
  
  
  getShortDate: function(date) {
	  var daynames = ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
	  var monthnames = ["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];
	    var day = date.getDate(); //1-31
	    var nameofday = date.getDay(); //0-6
	    var month = date.getMonth()+1; //0-11
	    var year = date.getFullYear();
	    if (day < 10) day = "0" + day; //keep width
	    
	    return ( daynames[nameofday] + ", " + monthnames[month-1] + " " + day + ", " + year );
  }
  
  
});



OBP.Firmware = function() {};

$.extend(OBP.Firmware, {

  update: function() {
	  
	  if (OBP.jsonData !== "") {
			
            var gatewayname = OBP.jsonData.devstatus.Gateway_Type;
            if (gatewayname != null)
            {
                $('#GateWayNameField').html(gatewayname);
            }
            
            var ports = OBP.jsonData.devstatus.ports;
			var outlist=[];
			
			outlist.push( "<li><span>Mate 3</span><span> Firmware: </span>&#09;<span id='NewReeFie'> </span></li>" ); //Mate 3 firmware
			
                        
                        // test for new GS firmware, if true, select fields (need a selectable class added to them) to switch how fields are displayed
			for(var name in ports) {
				var devname = ports[name].Dev;
				var portnum = ports[name].Port;
				var idname = "PotDeeFie_";
				
				if (devname === "CC") {
					idname = "PotDeeMolFie_";
					//use Model of charge controller (MX, FM, EX)
					devname = ports[name].Type;
				}
				
				var fwtxt = "<li><span>Port: " + portnum +
						"</span>&#09;<span>" + devname +
						" Firmware: </span>&#09;<span id='" + idname +
						+ portnum +
						"'> </span></li>";
				outlist.push( fwtxt );
			}
			$('#firmware_list').html( outlist.join("") );
		}
	  
  }
});



OBP.Status = function() {};

$.extend(OBP.Status, {
  htmlDataMap: {
    "FNDC" : {
		"#battery_charge" : "SOC",
		"#battery_charge_header" : "SOC",
		"#ch_a_amp" : "Shunt_A_I",
		"#ch_b_amp" : "Shunt_B_I",
		"#ch_c_amp" : "Shunt_C_I",
		"#days_since_full" : "Days_since_full",
		"#todays_minimum_charge" : "Min_SOC",
		"#net_battery_ah" : "Net_CFC_AH",
		"#net_battery_kwh" : "Net_CFC_kWh"  
    }
  },

  update: function() {
	  if (OBP.jsonData !== "") { //don't do if there is nothing to work with
		// update the system time
	    var timeStamp = OBP.jsonData.devstatus.Sys_Time + "000";

	    var d = new Date();
	    var gmtoffset = d.getTimezoneOffset() * 60000; //turn minutes into milliseconds
	    var localdatestamp = parseInt(timeStamp, 10) + gmtoffset;
	    var date = new Date(localdatestamp);
	    
	    //$("#current_time").html(date.toString()); //current_time appears to be a reserved label (somewhere)
	    $("#status_time").html(OBP.getShortDate(date) + " " + OBP.getShortTime(date)); //working code
	  
	  
	  
	  var ports = OBP.jsonData.devstatus.ports;
	  
	  var warncount = 0;
	  var errcount = 0;
	  var warns = [];
	  var errs = [];
	  
	  for (var pc=0; pc<ports.length; pc++) {
		  var selected = ports[pc];
		  var errslist = selected["Error"];
		  var warnslist = selected["Warn"];
		  
		  //alert(warnlist.toString());
		  
		  if (typeof errslist !== "undefined") {
		  //if (errslist != "{}") { //empty JSON
				  if (errslist[0] !== "none") {
					  var portnum = selected["Port"];
					  var porterrcount = errslist.length;
					  errs.push("<ul>");
					  errs.push("<li><span>Port " + portnum + "</span><br/></li>");
					  errcount += porterrcount;
					  for (var w=0; w<porterrcount; w++) {
						errs.push("<li>" + errslist[w] + "</li>");
						//alert(errslist[w]);
					  }
					  errs.push("</ul>");
				  }
			  }
		  
		  if (typeof warnslist !== "undefined") {
		  //if (warnslist != "{}") { //empty JSON
			  if (warnslist[0] !== "none") {
				  var portnum = selected["Port"];
				  var portwarncount = warnslist.length;
				  warns.push("<ul>");
				  warns.push("<li><span>Port " + portnum + "</span><br/></li>");
				  warncount += portwarncount;
				  for (var w=0; w<portwarncount; w++) {
					warns.push("<li>" + warnslist[w] + "</li>");
				  }
				  warns.push("</ul>");
			  }
		  }
		  
	  }
	  
	  if ((errcount > 0) || (warncount > 0)) {
		  $('#warner').removeClass("hidden");
		  if (errcount > 0) {
			  $('#err_label').addClass("errs"); //Hey blinkin!
		  } else {
			  $('#err_label').removeClass("errs");
		  }
		  $("#error_count").html(errcount);
		  $("#warning_count").html(warncount);
		  
		  $("#errlist").html(errs.join(""));
		  $("#warnlist").html(warns.join(""));	  
		  
	  } else {
		  $('#warner').addClass("hidden");
	  }
	  
	  
	  }
	  
    var FNDC = OBP.getDevices('FNDC')[0];
    if (FNDC) {
      var totamp = 0;
      //var convertshortcut = OBP.applyConversionFactor; //more shortcutting
      var fndcmap = this.htmlDataMap.FNDC;
	  
      for(var item in fndcmap ) {
        //var regex = /ch_/; //repaired regex after variable name changes; was "/channel/"
        //			I still don't like regex
        
        var testFor = "#ch_";   //removed regex.
        var channelTest = ( 0 === item.indexOf(testFor) );
        
        if (channelTest) { //(regex.test(item)) { //perhaps addressof "ch_" == 0?
          var shuntCurrent = FNDC[fndcmap[item]];
          if (shuntCurrent !== undefined) totamp += parseFloat(shuntCurrent);  // prevents NaN from getting added to the calculation for disabled shunts
        }
        var jsonSelector = fndcmap[item];
        var value = FNDC[jsonSelector];
        value = ((value === undefined) && channelTest) ? 0.0 : value;  // this will output 0 for disabled shunts
        //value = ((value === undefined) && regex.test(item)) ? 0.0 : value;
        //value = convertshortcut(value, "FNDC." + jsonSelector, true);
        //value = OBP.applyConversionFactor(value, "FNDC." + jsonSelector, true);
        $(item).html(value);
      }
      $('#total_amp').html(totamp.toFixed(1) + " ADC");
      $('#total_amp_header').html(totamp.toFixed(1) + " ADC");
    }
  }
});

OBP.Battery = function() {};

$.extend(OBP.Battery, {
  htmlDataMap: {
    "Battery" : {
      "#max_v_today" : "today_max_batt",
      "#min_v_today" : "today_min_batt",
      "#max_v_since_reset" : "sys_max_batt",
      "#min_v_since_reset" : "sys_min_batt"//,
      
//      "#time_stamp_min_v_today" : "today_min_batt_time",
//	  "#time_stamp_max_v_today" : "today_max_batt_time",
//	  "#time_stamp_min_v_since_reset" : "sys_min_batt_time",
//	  "#time_stamp_max_v_since_reset" : "sys_max_batt_time"
    }
  },

  
  
  update: function() {
    var battery = OBP.batteryData.sys_battery;
    //var totalCurrent = 0;
	var battmap = this.htmlDataMap.Battery;
	
    for(var item in battmap ) {
      var jsonSelector = battmap[item];
      var value = battery[jsonSelector];

/*
      //value = OBP.applyConversionFactor(value, "Battery." + jsonSelector, true);
      if (jsonSelector.indexOf("min") !== -1) {
    	  $(item).html(value);
      } else {
    	  $(item).html(value);
      }
	  */
		$(item).html(value + " VDC");

    }
    
    
    var d = new Date();
    //var yr = d.getFullYear();
    //var jn = new Date(yr,0);
    var gmtoffset = d.getTimezoneOffset() * 60000; //turn minutes into milliseconds
    
	var gst = OBP.getShortTime;
	var gsd = OBP.getShortDate;
    
    var timeStamp = battery.sys_min_batt_time + "000";
    var localdatestamp = parseInt(timeStamp, 10) + gmtoffset;
    var date = new Date(localdatestamp);
    $("#time_stamp_min_v_since_reset").html(gsd(date) + " " + gst(date));
    
    
    timeStamp = battery.sys_max_batt_time + "000";
    localdatestamp = parseInt(timeStamp, 10) + gmtoffset;
    date = new Date(localdatestamp);
    $("#time_stamp_max_v_since_reset").html(gsd(date) + " " + gst(date));
    
    
    timeStamp = battery.today_min_batt_time + "000";
    localdatestamp = parseInt(timeStamp, 10) + gmtoffset;
    date = new Date(localdatestamp);
    $("#time_stamp_min_v_today").html(gst(date));
    
    timeStamp = battery.today_max_batt_time + "000";
    localdatestamp = parseInt(timeStamp, 10) + gmtoffset;
    date = new Date(localdatestamp);
    $("#time_stamp_max_v_today").html(gst(date));
    
  }
});



OBP.newMode = function() {};

$.extend(OBP.newMode, {
	
	mode_fields : {
		"#current_time" : "Time_Stamp",
		
		"inverters" : {
			"#ac_input_port" : "AC_mode",
			"#inv_mode_port" : "INV_mode",
			"#inv_aux_output_state": "AUX",
			"#gs_aux_output_state": "RELAY"
			},
		"chargers" : {
			"#cc_mode": "CC_mode",
			"#cc_aux_output_state": "AUX",
			"#cc_aux_program_mode": "Aux_mode"
			},
		"fndc" : {
			"#fndc_aux_state": "AUX",
			"#fndc_aux_output_mode": "Aux_mode"
			}
	},

	update: function() {
	
		if (OBP.jsonData !== "") {
			var ports = OBP.jsonData.devstatus.ports;
			
			var invcntr = 0;
			
			for(var name in ports) {
				var devname = ports[name].Dev;
				var portnum = ports[name].Port;
				var map = "";
				var fn = 0;
				
				if ((devname === "FX") || (devname.slice(0, 2) === "GS") || (devname === "FXR") ) {
					map = this.mode_fields.inverters;
					invcntr = invcntr + 1;
					
				} else if (devname === "CC") {
					map = this.mode_fields.chargers;
					
				} else if (devname === "FNDC") {
					map = this.mode_fields.fndc;
					fn = fn + 1;
					
				}
				
				for (var field in map ) {
					if (fn < 1) {
						$( field + "_" + portnum).text( ports[name][map[field]] );
					} else {
						$( field ).text( ports[name][map[field]] );
					}
				}
				
				if ((invcntr>0) && (invcntr<2)) {
					$( "#ac_input_global").text( ports[name]["AC_mode"] );
				}
				
			}
		}
	
	}
  


});



OBP.Meters = function() {};

$.extend(OBP.Meters, {

	/*
 htmlDataMap: {
    "fndc" : {	//just hardcode FNDC stuff in Update()
      "#ch_a_sum_ah" : "Shunt_A_AH",
      "#ch_b_sum_ah" : "Shunt_B_AH",
      "#ch_c_sum_ah" : "Shunt_C_AH",
      "#ch_a_sum_kwh" : "Shunt_A_kWh",
      "#ch_b_sum_kwh" : "Shunt_B_kWh",
      "#ch_c_sum_kwh" : "Shunt_C_kWh",
      "#todays_net_input_ah" : "In_AH_today",
      "#todays_net_input_kwh" : "In_kWh_today",
      "#todays_net_output_ah" : "Out_AH_today",
      "#todays_net_output_kwh" : "Out_kWh_today",
      "#battery_temperature" : "Batt_temp"
    }   
  },
  */
	
	porthtmlmap : {
    "inv_s" : {
		"#inv_ac_amp_to_loads" : "Inv_I",
		"#inv_charge_amp" : "Chg_I",
		"#inv_buy_amp" : "Buy_I",
		"#inv_input_v" : "VAC_in",
		"#inv_output_v" : "VAC_out",
		"#inv_sell_amp" : "Sell_I",
		"#inv_batt_volt" : "Batt_V"
    },
    
    "gs_z" : {
  		"#inv_ac_amp_to_loads" : ["Inv_I_L1","Inv_I_L2","maac"], //keep this in place at gs_z[0] to help build tables
  		"#inv_charge_amp" : ["Chg_I_L1", "Chg_I_L2","maac"],
  		"#inv_buy_amp" : ["Buy_I_L1","Buy_I_L2","maac"],
  		"#inv_input_v_ac1" : ["VAC1_in_L1","VAC1_in_L2","mvac"],
  		"#inv_input_v_ac2" : ["VAC2_in_L1","VAC2_in_L2","mvac"],
  		"#inv_output_v" : ["VAC_out_L1","VAC_out_L2","mvac"],
  		"#inv_sell_amp" : ["Sell_I_L1","Sell_I_L2","maac"],
  		"#inv_batt_volt" : ["Batt_V", "Batt_V", "mvdc meter_batt"] //duplicate field name is on purpose, helps automate filling in values
    },
    
    "cc_s" : {
		"#cc_kwh" : "Out_kWh",
		"#cc_amps_dc" : "Out_I",
		"#cc_pv_amps_dc" : "In_I",
		"#cc_daily_ah" : "Out_AH",
		"#cc_pv_v" : "In_V",
		"#cc_batt_v" : "Batt_V"
    }
  },

  
  constructGS: function() {
	var mapsource = this.porthtmlmap;
  	var map = mapsource.gs_z;
	//Copy fields for any GS
	for (var port=0; port<11; port++) {
            for (var field in map) {

                var targ = field + "_" + port; 

                //remove # char
                var fieldlite = targ.substring(1, targ.length);

                var typ = map[field][2];

                if (OBP.gssph || (field==="#inv_batt_volt") ) {
                        var sel = $(targ); //don't add sub fields
                        sel.attr('id', fieldlite); //add port number
                        sel.addClass( typ ); //make it the right type

                } else {
                        var selA = fieldlite + "_A";
                        var selB = fieldlite + "_B";

                        $(targ).html( "<ul><li class='" + typ + "' id='" + selA + "'></li><li class='" + typ + "' id='" + selB + "'></li></ul>" );
                }

            }
	}
  },
	
  update: function() {
    
	var mapsource = this.porthtmlmap;
	
	//Radians/FX
    var invs = OBP.getInvs();
    if (OBP.isgs) { //Radians
    	var map = mapsource.gs_z;
    	$.each(invs, function(index) {
    		var selectedinv = invs[index];
    		var portn = selectedinv["Port"];
    		var fcount = 0;
    		
    		for (var field in map) {
    			var arry = map[field];
    			
    			if (OBP.gssph || (field==="#inv_batt_volt") ) {
					var sel = field + "_" + portn;
        	        $(sel).html( selectedinv[ arry[1] ] ); //for a single phase, use the second value
        			
    			} else {
					var selA = field + "_" + portn + "_A";
        			var selB = field + "_" + portn + "_B";
    				
    				if (fcount > 0) {
    					$(selA).text( selectedinv[ arry[0] ] );
    					$(selB).text( selectedinv[ arry[1] ] );
    				} else {
    					$(selA).text( "L1: " + selectedinv[ arry[0] ] );
    					$(selB).text( "L2: " + selectedinv[ arry[1] ] );
    				}
					
    			}
    			
    			fcount = fcount + 1;
    		}
        });
    	
    } else { //FX inverters
    	var map = mapsource.inv_s;
    	$.each(invs, function(index) {
    		var selectedinv = invs[index];
    		var portn = selectedinv["Port"];
    		for (var i in map) {
    			var selector = i + "_" + portn;
    	        $(selector).text( selectedinv[map[i]] );
    		}
        });
    }
	
    
    //Charge controllers
    var ccmap = mapsource.cc_s;
    var ccs = OBP.getCCs();
	$.each(ccs, function(index) {
		var selectedcc = ccs[index];
		var portn = selectedcc["Port"];
		for (var i in ccmap) {
			var selector = i + "_" + portn;
	        $(selector).text( selectedcc[ccmap[i]] );
		}
    });
    
    
	//FNDC
    var fndc = OBP.getDevices('FNDC')[0];
    if (fndc) {
      var accumulatedAH = 0;
      var accumulatedKWH = 0;
      var shuntCurrent;
      var pf = parseFloat;
      
	  var targets = ["#ch_a_sum_ah", "#ch_b_sum_ah", "#ch_c_sum_ah",
	                 "#ch_a_sum_kwh", "#ch_b_sum_kwh", "#ch_c_sum_kwh"];
	  
	  var sources = ["Shunt_A_AH", "Shunt_B_AH", "Shunt_C_AH",
	                 "Shunt_A_kWh", "Shunt_B_kWh", "Shunt_C_kWh"];
	  
	  for (var t=0; t<targets.length; t++) {
		  shuntCurrent = fndc[ sources[t] ];
		  if (shuntCurrent !== undefined) {
			  if (t>2) {
				  accumulatedKWH += pf(shuntCurrent);
			  } else {
				  accumulatedAH += pf(shuntCurrent);
			  }
			  $( targets[t] ).text( shuntCurrent );
		  }
	  }
	  /*
	  shuntCurrent = fndc["Shunt_A_AH"];
	  if (shuntCurrent != undefined) {
		  accumulatedAH += pf(shuntCurrent);
		  $("#ch_a_sum_ah").text( shuntCurrent );
	  }
	  shuntCurrent = fndc["Shunt_B_AH"];
	  if (shuntCurrent != undefined) {
		  accumulatedAH += pf(shuntCurrent);
		  $("#ch_b_sum_ah").text( shuntCurrent );
	  }
	  shuntCurrent = fndc["Shunt_C_AH"];
	  if (shuntCurrent != undefined) {
		  accumulatedAH += pf(shuntCurrent);
		  $("#ch_c_sum_ah").text( shuntCurrent );
	  }
	  
	  shuntCurrent = fndc["Shunt_A_kWh"];
	  if (shuntCurrent != undefined) {
		  accumulatedKWH += pf(shuntCurrent);
		  $("#ch_a_sum_kwh").text( shuntCurrent );
	  }
	  shuntCurrent = fndc["Shunt_B_kWh"];
	  if (shuntCurrent != undefined) {
		  accumulatedKWH += pf(shuntCurrent);
		  $("#ch_b_sum_kwh").text( shuntCurrent );
	  }
	  shuntCurrent = fndc["Shunt_C_kWh"];
	  if (shuntCurrent != undefined) {
		  accumulatedKWH += pf(shuntCurrent);
		  $("#ch_c_sum_kwh").text( shuntCurrent );
	  }
	  */
	  
	  $("#todays_net_input_ah").text( fndc["In_AH_today"] );
	  $("#todays_net_input_kwh").text( fndc["In_kWh_today"] );
	  $("#todays_net_output_ah").text( fndc["Out_AH_today"] );
	  $("#todays_net_output_kwh").text( fndc["Out_kWh_today"] );
	  
          $("#battery_temperature").html(fndc["Batt_temp"]);
          
      $('#total_sum_ah').html(accumulatedAH.toFixed(0) + " Ah");
      $('#total_sum_kwh').html(accumulatedKWH.toFixed(3) + " kWh"); 
    }
    
    
    var batteryVoltage = OBP.jsonData.devstatus.Sys_Batt_V;
    $("#battery_v").html(batteryVoltage);
    $("#battery_v_status").html(batteryVoltage);
  }
});


OBP.populateXML = function() {};

$.extend(OBP.populateXML, {
	
	depth: 0,
	stack: [],
	currentport: "",
        numericport: 0,
	globalinvport: "",
        // Flag FM100 to mark sweep settings to "N/A". Filled in by pushpull()
        isMVCC: [0,0,0,0, 0,0,0,0, 0,0,0],
		
	exec: function() {
		var xml = OBP.xmlDoc;
		var localname = OBP.populateXML;
		
		if (xml !== "") {
			localname.depth = 0;
			//html=[];
			localname.stack=[];
			//pathstack=[];
			localname.currentport = "";
			localname.globalinvport = "";
			
			
			//Recursive pass through config.xml
			$(xml).children().each(this.pushpull);
			
			
                        
                        //Fill in Mode tab fields
                        
			//Global Inverter
			$('#inv_mode_global').text( $('#PotDeeInr_Mode' + localname.globalinvport).text() );
			$('#charger_mode').text( $('#PotDeeChr_Mode' + localname.globalinvport).text() );
			
			//AC control modes
			$('#modetab_ags_mode').text( $('#NewReeAdeGerStt_Mode').text() );
			$('#modetab_hbx_mode').text( $('#NewReeHihBayTrr_Mode').text() );
			$('#modetab_lgt_mode').text( $('#NewReeLodGrdTrr_Mode').text() );
			$('#modetab_gu_mode').text( $('#NewReeGrdUse_Mode').text() );
			$('#modetab_gu2_mode').text( $('#NewReeGrdUseP22_Mode').text() );
			$('#modetab_gu3_mode').text( $('#NewReeGrdUseP33_Mode').text() );
			$('#modetab_qt_mode').text( $('#NewReeAdeGerSttQutTie_Mode').text() );
			$('#modetab_mr_mode').text( $('#NewReeAdeGerSttMutRun_Mode').text() );
			$('#modetab_ls_mode').text( $('#NewReeAdeGerSttLodStt_Mode').text() );
			$('#modetab_ex_mode').text( $('#NewReeAdeGerSttGerExe_Mode').text() );
			
			
                        var isNewGSRev = false;
                        //Find firmware rev of master GS
                        if (OBP.isgs) {
                            var masterGSport = OBP.getGlobalInverter()["Port"];
                            
                            var rev = $('#PotDeeFie_' + masterGSport).html();
                            
                            var vals = rev.toString().split('.');
                            
                            var major = parseInt(vals[0], 10);
                            var minor = parseInt(vals[1], 10);
                            var fix = parseInt(vals[2], 10);
                            
                            var codeMilestone = 1005000; //001.005.000
                                
                            var someBigNumber = (major*1000000) + (minor*1000) + fix;
                            
                            
                            if (someBigNumber > codeMilestone) {
                                isNewGSRev = true;
                            }

                        }
                
                
			for (var pcnt=0; pcnt<11; pcnt++) {
				if (OBP.isgs) {
                                    //GS
                                    $('#gs_aux_program_mode_' + pcnt).text( $('#PotDeeRey_Mode_' + pcnt).text() );
                                    $('#gs_aux_operation_mode_' + pcnt).text( $('#PotDeeReyOpnMoe_' + pcnt).text() );
                                    if (isNewGSRev) {
                                        $('#PotDeeAC1intTrrDey_' + pcnt).attr("class", "tfrdelay sec");
                                        $('#PotDeeAC2intTrrDey_' + pcnt).attr("class", "tfrdelay sec");
                                    }
                                }// else {
                                    //FX
                                    $('#inv_aux_program_mode_' + pcnt).text( $('#PotDeeAUXOutOpnMoe_' + pcnt).text() );
                                    $('#inv_aux_operation_mode_' + pcnt).text( $('#PotDeeAUXOut_Mode_' + pcnt).text() );
                                //}
				//CC
				$('#cc_aux_operation_mode_' + pcnt).text( $('#PotDeeMolAUXOut_Mode_' + pcnt).text() );
				if (1 === localname.isMVCC[ pcnt ]) // is an FM100
                                {
                                    $('#PotDeeMolMPTSwpMoe_' + pcnt).text("N/A");
                                    $('#PotDeeMolMPTMaxSwp_' + pcnt).text("N/A");
                                }
			}
		}

	},

	// This method assumes that the XML file is well-formed
	pushpull: function(obj) {
		var nm = this.tagName;
		var localname = OBP.populateXML;
		
		localname.depth = localname.depth + 1;
		
		if (localname.depth > 1) { //trim "System_Config" from every field
			var tagwords = nm.split("_");
			var letters=[];
			var L = tagwords.length;
			
			for (var t=0; t<L; t++) {
				var tw=tagwords[t];
                                letters.push( tw.substring(0,2) + tw.slice(-1) ); //first pair + last letter
			}
			localname.stack.push( letters.join("") );
			
			//attempt at IE8 compatibility:
			var modeattr = this.getAttribute('Mode');
			if (modeattr !== null) {
				var target = "#" + localname.stack.join("") + "_Mode" + localname.currentport;
				$( target ).html( modeattr );
			}
			
			var portattr = this.getAttribute('Num');
			if (portattr !== null) {
                            var pn = this.getAttribute('Num');
                            localname.numericport = parseInt(pn);
                            localname.currentport = "_" + pn;
			}
			
			var typeattr = this.getAttribute('Type');
			if (typeattr !== null) {
				var target = "#" + localname.stack.join("") + "_Type" + localname.currentport;
				
				$( target ).html( typeattr );
				if (localname.globalinvport === "") {
					if ((typeattr==="FX") || (typeattr==="GS") || (typeattr==="GSS") || (typeattr==="FXR")) {
						localname.globalinvport = localname.currentport;
					}
				}
                                
                                if (typeattr === "MV")
                                {
                                    localname.isMVCC[localname.numericport] = 1;
                                }
			}
                }

                var haskids = $(this).children().length > 0;
                if( haskids ) {
                    $(this).children().each(OBP.populateXML.pushpull);
                } else {
                       var name = "#" + localname.stack.join("") + localname.currentport;
                       $( name ).html( $(this).text() );
                }
                localname.stack.pop();
		localname.depth = localname.depth - 1;
	}
});



$.fn.toggleNextSection = function() { 
  return this.each( function() {
    $(this).parent().children().not('h3').toggle();
    $(this).children().siblings().toggle();
  });
};



$(document).ready(
    function() { 
        // $('h3.status_h3').toggleNextSection();
        $('#SysTie').text("Please wait while loading configuration"); // Replace message showing "please enable Javascript"

        var obscriptrev = " :: JS Rev: one dot oh";
        $('#pagerev').append(document.createTextNode(obscriptrev));
        
        $('div.info > h3').click(function (e) {
                $(this).toggleNextSection(); 
                $(this).toggleClass("collapse");
                return false;	 
        });


        $('#nav ul li a').click(function (e) { 
                OBP.displaySection($(this));  
                return false;
        });
        // $('span.folding_subsection').click(function (e) {
                // $(this).toggleNextSub();
                // return false; 
        // });


        //No longer need this
        //var conversionXmlJQXHR = $.ajax({ url: OBP.conversionFactorsXMLPath, dataType: 'xml', success: OBP.loadConversionFactors, error: OBP.updateXMLError, context: OBP, async: false});


        OBP.updateDisplay();
        OBP.displaySection( $('#status_tab').first() );
        setInterval( "OBP.updateDisplay()", 5000 );
    }
);
